<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemCategoryModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemcategory';
    protected $primaryKey       = 'ICID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ICID', 'ICName', 'ICLink', 'ICParentID', 'ICCreatedAt', 'ICUpdatedAt', 'ICDeletedAt', 'ICStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ICCreatedAt';
    protected $updatedField  = 'ICUpdatedAt';
    protected $deletedField  = 'ICDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all categories data    
    function getAllCategories(){

        $data= $this->db
            ->table('itemcategory')
            ->where('ICStatus', '1')
            ->join('itemcategorydetails', 'itemcategory.ICID = itemcategorydetails.ICID')
            //->orderBy('ICID ', 'ASC')
            ->get()
            ->getResultArray();

        return $data;
    }
    
    // save categories data
    function insertCategories($data){    
        return $this->db
            ->table('itemcategory')
            ->insert($data);
	}

    // get single item category data
    function getSingleICData($id){

        return $this->db
            ->table('itemcategory')
                //->join('itemcategory', 'itemcategory.ICParentID= itemcategory.ICID')
            ->where(["ICID" => $id])
            ->get()
                ->getRow();
    }
    
    // update categories
    function updateItemCatgories($id,$data){

        return $this->db
            ->table('itemcategory')
            ->where(["ICID" => $id])
            ->set($data)
            ->update();

    }
    
    // delete categories
    function deleteCategories($id,$data){
      
        return $this->db
            ->table('itemcategory')
            ->where(["ICID" => $id])
            ->set($data)
            ->update();
    }
}
